if (console && console.log) {
    console.log("%cWorker Started", "color : #FF00FF");
}

if (typeof EventSource === "undefined") {
    importScripts("/vendor/eventsource/eventsource.min.js?" + (new Date).getTime());
}

start();

function start()
{
    self.xhr = null;
    let splitOnFirst = function (s, c) { if (!s) return [s]; let pos = s.indexOf(c); return pos >= 0 ? [s.substring(0, pos), s.substring(pos + 1)] : [s]; };
    let heartBeatURL = "";
    let eventSource = new EventSource("/api/event-stream?channel=workbook,system&t=" + new Date().getTime());
    let abortcont = new AbortController();
    let testTimer = setTimeout(connectiontest.bind(eventSource), 10000);
    setInterval(statusTest.bind(eventSource), 5000);
    function connectiontest() {
        // 0 is Connecting, 2 is Disconnected
        if (this.readyState != 1)
        {
            postConnectionLost("Readystate != 1");
            eventSource.close();
            clearTimeout(testTimer);
            abort();
        }
    }

    function statusTest() {
        self.postMessage({ command: "state", data: this.readyState });
    }

    self.onmessage = function (msg) {
        if (msg.data[0] == "KILLME") {
            abort();
        }
    }
    //The error event of the EventSource API is fired when a connection with an event source fails to be opened. (https://developer.mozilla.org/en-US/docs/Web/API/EventSource/error_event)
    eventSource.addEventListener("error", function (e) {
        self.postMessage({ command: "closing", data : e.message });
    }, false);

    eventSource.onmessage = function (e) {

        try {
            // This is stolen from ServiceStack SS-Util to split up the message payload.
            let parts = splitOnFirst(e.data, " ");
            let selector = parts[0];
            let selParts = splitOnFirst(selector, "@");

            if (selParts.length > 1) {
                e.channel = selParts[0];
                selector = selParts[1];
            }

            let json = parts[1];
            let msg = json ? JSON.parse(json) : null;

            parts = splitOnFirst(selector, ".");
            if (parts.length <= 1) {
                throw new Error("invalid selector format: " + selector);
            }

            let target = parts[1].replace(/%20/g, " ");

            let tokens = splitOnFirst(target, "$"),
                cmd = tokens[0];

            if (msg.hasOwnProperty("heartbeatUrl")) {
                heartBeatURL = msg.heartbeatUrl;
            }

            if (cmd === "onMessage") {
                self.postMessage({ command: "message", data: msg });
            }
        }
        catch (e) {
            self.postMessage({ command: "messageexception", data: e.message });
         
        }
    }


    eventSource.addEventListener("open", function (e) {
       setInterval(heartBeat, 10000);

        self.postMessage({ command: "connect", data: null });
    }, false);


    function heartBeat() {
        
        let headers = new Headers();
        headers.set("Content-Type", "text/plain");

        if (heartBeatURL.length === 0) {
            return;
        }

        // Rewrite the url to be the relative path in case the server has a different address or port than the client
        // This is mainly the case when running locally through the Vite Proxy
        // This should only run once pr worker initialization as the server will return
        // the same addrees in the heartbeat response
        if (heartBeatURL.startsWith("https://") || heartBeatURL.startsWith("http://")) {
            const hbURL = new URL(heartBeatURL);
            heartBeatURL = hbURL.pathname + hbURL.search;
        }

        let signal = abortcont.signal;

        fetch(new Request(heartBeatURL, { method: "POST", mode: "cors", headers: headers, signal : signal }))
            .then(res => {
                if (!res.ok) {
                    postConnectionLost(`${res.status} - ${res.statusText}`);
                }
                else {
                    self.postMessage({ command: "heartbeat" });
                }
            })
            .catch(error => postConnectionLost(error.message));
    }

    function postConnectionLost(message) {
        self.postMessage({ command: "connectionlost", data: message });
    }     

    function abort() {
        if (abortcont != null) {
            abortcont.abort();
        }

        eventSource.close();
        self.postMessage({ command: "closing", data: "aborting" });
        setTimeout(function () { self.close(); }, 100);
    }
}

