﻿
// This file should only be run using "npm run svg:build"

// Modules
const fs = require("fs");
const path = require("path");

const DIR = __dirname;

// Icon names for d.ts file
const svgNames = [];
const coloredSvgNames = [];

console.log("Gathering icon data...")

const svgFolder = `${DIR}/SVG/`;
let svgOutput = "";

fs.readdirSync(svgFolder).forEach(file => {
    const fn = `${svgFolder}${file}`;
    if (fn.substr(-4) === ".svg") {
        const base = path.basename(fn, ".svg");
        let data = fs.readFileSync(fn, "utf8");
        if (data != undefined) {
            svgNames.push(base);
            svgOutput += data
                .replace(/<\?xml[^>].*?\?>\s*/, "")
                .replace(/<svg[^>]*?>\s*/, "<g id=\"svg-" + base + "\">")
                .replace(/<!--.*?-->\s*/, "")
                .replace(/<\/svg>\s*/, "</g>")
                .replace(/\r\n\t/, "");
        }
    }
});

console.log("Updating images.html...");

const imagesFile = `${DIR}/images.html`;
fs.writeFile(imagesFile, svgOutput, "utf8", () => null);

const coloredSvgFolder = `${DIR}/SVG/coloured/`;
fs.readdirSync(coloredSvgFolder).forEach(file => {
    const fn = coloredSvgFolder + file;
    if (fn.substr(-4) === ".svg") {
        const base = path.basename(fn, ".svg");
        let data = fs.readFileSync(fn, "utf8");
        if (data != undefined) {
            coloredSvgNames.push(base);
        }
    }
});

console.log(`Updating svgicons.d.ts...`);

const formatEnumName = value => {
    let out = `${value.replace(/[^a-z0-9_]/ig, "_")}`;
    if ("0123456789".indexOf(out[0]) !== -1) {
        out = `_${out}`;
    }
    return out;
};
const indent = " ".repeat(4);
const tsTypeFile = `${DIR}/../../typescript/global/enums/svgicons.ts`;
const svgNamesString = svgNames.map(x => `${indent}${formatEnumName(x)} = "${x}"`).join(",\n");
const coloredSvgNamesString = coloredSvgNames.map(x => `${indent}${formatEnumName(x)} = "${x}"`).join(",\n");
const contents = (
    `// tslint:disable\n\n` +
    `// Generated by NPM script "svg:build"\n\n` +
    `export enum SvgPlainIcon {\n` +
        `${svgNamesString}\n` +
    `}\n\n` +
    `export enum SvgColoredIcon {\n` +
        `${coloredSvgNamesString}\n` +
    `}\n`
);

fs.writeFile(tsTypeFile, contents, "utf8", () => null);

console.log(`Updating images.txt with colored icon file names...`);

const txtFile = `${DIR}/images.txt`;
const coloredSvgNamesForTxtFile = coloredSvgNames.map(x => `${x}.svg`).join(",\n") + "\n";
fs.writeFile(txtFile, coloredSvgNamesForTxtFile, "utf8", () => null);
