﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Edit.aspx.cs" Inherits="WorkBook.Report.WebSite.Edit" Async="true" AsyncTimeout="3600" %>

<%@ Register Assembly="DevExpress.Web.v20.1, Version=20.1.4.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.Web" TagPrefix="dx" %>

<%@ Register Assembly="DevExpress.XtraReports.v20.1.Web.WebForms, Version=20.1.4.0, Culture=neutral, PublicKeyToken=b88d1754d700e49a" Namespace="DevExpress.XtraReports.Web" TagPrefix="dx" %>

<!DOCTYPE html>

<html>
<head runat="server">
    <title>WorkBook Online Report Editor</title>
    <style>
        body {
            margin: 0;
            padding: 0;
        }

        .fullscreen {
            position: absolute;
            bottom: 0;
            right: 0;
            height: 100% !important;
        }

        .dxrd-image-workbook_server_report_xrworkbooksubreportcontrol {
            background-image: url(data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxzdHlsZT4uc3Qwe2ZpbGw6I2ZmZmZmZjt9PC9zdHlsZT48cGF0aCBjbGFzcz0ic3QwIiBkPSJNOCAwaDZ2NEg4eiIvPjxwYXRoIGNsYXNzPSJzdDAiIGQ9Ik0xNiAydjJoMnYxOEg0VjRoMlYySDJ2MjJoMThWMnoiLz48cGF0aCBjbGFzcz0ic3QwIiBkPSJNNiA2djE0aDEwVjZINnptOCAxMkg4di0yaDZ2MnptMC00SDh2LTJoNnYyem0wLTRIOFY4aDZ2MnoiLz48L3N2Zz4=);
            background-repeat: no-repeat;
        }

        .customButtonLocalize {
            background-image: url(data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxzdHlsZT4uc3Qwe2ZpbGw6I2ZmZmZmZjt9PC9zdHlsZT48cGF0aCBjbGFzcz0ic3QwIiBkPSJNOCAwaDZ2NEg4eiIvPjxwYXRoIGNsYXNzPSJzdDAiIGQ9Ik0xNiAydjJoMnYxOEg0VjRoMlYySDJ2MjJoMThWMnoiLz48cGF0aCBjbGFzcz0ic3QwIiBkPSJNNiA2djE0aDEwVjZINnptOCAxMkg4di0yaDZ2MnptMC00SDh2LTJoNnYyem0wLTRIOFY4aDZ2MnoiLz48L3N2Zz4=);
            background-repeat: no-repeat;
            height: 20px;
            width: 20px;
        }
    </style>
    <script type="text/javascript">
        function ShowSaveAsDialog() {
            LayoutNamePopup.Show();
            layoutNameTextBox.Focus();
        }

        function reportDesigner_SaveCommandExecute(s, e) {
            e.handled = true;
            ShowSaveAsDialog();
        };

        function reportDesigner_onEndCallback(s, e) {
            if (s && s == reportDesigner) {
                if (reportDesigner.IsModified()) {
                    reportDesigner.ResetIsModified();
                    if (reportDesigner.shouldLocalize === true) {
                        reportDesigner_CustomizeMenuActions(s);
                    }
                }
            }
        };

        // Don't leave us!
        function goodbye(e) {
            try {
                if (reportDesigner.IsModified()) { // Only do the cancel stuff if the App says so.
                    if (!e) e = window.event;
                    e.cancelBubble = true; // Cancel navigation
                    e.returnValue = "You have unsaved modifications, are you sure you wish to leave?"; //This will display a pretty text in the dialog    

                    // Stop him from navigating away.
                    if (e.stopPropagation) {
                        e.stopPropagation();
                        e.preventDefault();
                    }

                    return "You have unsaved modifications, are you sure you wish to leave?"; //This will display a pretty text in the dialog (Chrome and Opera)
                }
            }
            catch (err) {
            }
        }

        function removeOpenCookie(e) {
            document.cookie = "ReportDesigner_Opened=false; path=/";
        }

        window.onbeforeunload = goodbye;
        window.onunload = removeOpenCookie;

        function CustomizeToolbox(s, e) {
            registerControls(s, e);
        };

        function CustomizeMenuActions(s, e) {
            // Only in wbMaster you can localize reports.
            var canLocalize = document.cookie.split(";").some(function (item) { return item.indexOf("ReportDesigner_CanLocalize=true") > -1 });
            if (!canLocalize) {
                return;
            }
            else {
                var actions = e.Actions;

                //Add a new action 
                actions.push({
                    text: "Localize",
                    imageClassName: "customButtonLocalize",
                    disabled: ko.observable(false),
                    visible: true,
                    hasSeparator: true,
                    // The clickAction handler receives the client-side report model  
                    // allowing you interact with the currently opened report on the client.  
                    clickAction: reportDesigner_CustomizeMenuActions,
                    container: "toolbar"
                });
            }
        };

        function reportDesigner_CustomizeMenuActions(s) {
            if (reportDesigner.IsModified()) {
                reportDesigner.shouldLocalize = true;
                ShowSaveAsDialog();
                return;
            }
            else {
                reportDesigner.shouldLocalize = false;
                __doPostBack("customButtonLocalize", "");
            }
        };
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <dx:ASPxReportDesigner ID="ASPxReportDesigner" runat="server" CssClass="fullscreen" ColorScheme="dark" OnSaveReportLayout="ASPxReportDesigner_SaveReportLayout" ClientInstanceName="reportDesigner">
            <ClientSideEvents SaveCommandExecute="reportDesigner_SaveCommandExecute" CustomizeToolbox="CustomizeToolbox" CustomizeMenuActions="CustomizeMenuActions" EndCallback="reportDesigner_onEndCallback"/>
        </dx:ASPxReportDesigner>
        <dx:ASPxPopupControl ID="LayoutNamePopup" ClientInstanceName="LayoutNamePopup" runat="server" CloseAction="CloseButton" CloseOnEscape="true" Modal="true" HeaderText="Save as" PopupVerticalAlign="WindowCenter" PopupHorizontalAlign="WindowCenter">
            <ContentCollection>
                <dx:PopupControlContentControl>
                    <dx:ASPxPanel runat="server">
                        <PanelCollection>
                            <dx:PanelContent>
                                <dx:ASPxLabel runat="server" Text="Layout name" AssociatedControlID="layoutNameTextBox"></dx:ASPxLabel>
                                <dx:ASPxTextBox runat="server" ID="layoutNameTextBox" ClientInstanceName="layoutNameTextBox" EnableClientSideAPI="true">
                                    <ValidationSettings CausesValidation="true" ErrorDisplayMode="Text" ErrorTextPosition="Bottom" ValidationGroup="layoutName">
                                        <RequiredField ErrorText="Layout name is required" IsRequired="true" />
                                    </ValidationSettings>
                                </dx:ASPxTextBox>
                                <table>
                                    <tr>
                                        <td>
                                            <dx:ASPxButton ID="btOK" runat="server" Text="Save" Width="80px" AutoPostBack="false" Style="float: left; margin-right: 8px">
                                                <ClientSideEvents Click="function(s, e) { if(ASPxClientEdit.ValidateGroup('layoutName')) { LayoutNamePopup.Hide(); reportDesigner.PerformCallback(); } }" />
                                            </dx:ASPxButton>
                                        </td>
                                        <td>
                                            <dx:ASPxButton ID="btCancel" runat="server" Text="Cancel" Width="80px" AutoPostBack="False" Style="float: left; margin-right: 8px">
                                                <ClientSideEvents Click="function(s, e) { LayoutNamePopup.Hide(); reportDesigner.CancelCallbackCore(); }" />
                                            </dx:ASPxButton>
                                        </td>
                                    </tr>
                                </table>
                            </dx:PanelContent>
                        </PanelCollection>
                    </dx:ASPxPanel>
                </dx:PopupControlContentControl>
            </ContentCollection>
        </dx:ASPxPopupControl>

        <asp:Label ID="errorLabel" runat="server" Visible="False" Font-Bold="true">Unable to edit reports that contain sub-reports</asp:Label>
    </form>
    <script type="text/javascript">
        function registerControls(s, e) {
            var controlsFactory = e.ControlsFactory;
            controlsFactory.registerControl("XRControl", {
                info: DevExpress.Reporting.Designer.Controls.Metadata.commonControlProperties.concat(DevExpress.Reporting.Designer.Controls.Metadata.commonScripts, DevExpress.Reporting.Designer.Controls.Metadata.sizeLocation),
                type: DevExpress.Reporting.Designer.Controls.XRControlViewModel,
                nonToolboxItem: true,
                surfaceType: DevExpress.Reporting.Designer.Controls.XRControlSurface
            });

            // Custom control registration 
            controlsFactory.registerControl("<%= typeof(WorkBook.Server.Report.XRWorkBookSubreportControl).FullName %>", {
                info: [].concat(DevExpress.Reporting.Designer.Controls.Metadata.subreportSerializationsInfo.slice(0), [{
                    propertyName: "reportID", displayName: "Report Id",
                    modelName: "@ReportID", defaultVal: "", editor: DevExpress.Analytics.Widgets.editorTemplates.text
                }, {
                    propertyName: "layoutID", displayName: "Layout Id",
                    modelName: "@LayoutID", defaultVal: "", editor: DevExpress.Analytics.Widgets.editorTemplates.text
                }]),
                defaultVal: {
                    "@ControlType": "<%= typeof(WorkBook.Server.Report.XRWorkBookSubreportControl).AssemblyQualifiedName %>",
                    "@SizeF": "100,23",
                    "@Name": "XRWorkBookSubreportControl"
                },
                type: DevExpress.Reporting.Designer.Controls.XRSubreportViewModel,
                surfaceType: DevExpress.Reporting.Designer.Controls.XRSubreportSurface,
                popularProperties: ["reportID", "layoutID"],
            });
        };
    </script>
</body>
</html>
